---
generated_at: 2026-02-03 10:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：44-use cache

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **SWCによるコード変換の詳細**：SWCプラグインのソースを未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/use-cache/use-cache-wrapper.ts`（1910行）
- E-02: `packages/next/src/server/use-cache/handlers.ts`（144行）
- E-03: `packages/next/src/server/use-cache/constants.ts`（3行）
- E-04: `packages/next/src/server/lib/cache-handlers/types.ts`（81行）
- E-05: 機能一覧.csv 44行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | "use cache"と"use cache: private"の2種類 | E-01 (843, 878行目) | ○ |
| C-02 | DYNAMIC_EXPIRE = 300秒 | E-03 (1行目) | ○ |
| C-03 | RUNTIME_PREFETCH_DYNAMIC_STALE = 30秒 | E-03 (2行目) | ○ |
| C-04 | プライベートキャッシュはpublic "use cache"内で使用不可 | E-01 (914-922行目) | ○ |
| C-05 | クリーンなAsyncLocalStorageスナップショットで実行 | E-01 (147行目) | ○ |
| C-06 | キャッシュキーはbuildId + id + args | E-01 (1152-1154行目) | ○ |
| C-07 | 50秒タイムアウト | E-01 (626-629行目) | ○ |
| C-08 | Draft Mode時はキャッシュを保存しない | E-01 (1635行目) | ○ |
| C-09 | CacheHandlerはdefault/remoteの2種類 | E-02 (55-66行目) | ○ |
| C-10 | プライベートキャッシュはRDCのみに保存 | E-01 (847行目) | ○ |
| C-11 | replayConsoleLogs: true | E-01 (1746行目) | ○ |
| C-12 | バインドされた引数はdecryptActionBoundArgsでデコード | E-01 (1125行目) | ○ |
| C-13 | 最近再検証されたタグでRDCエントリを破棄 | E-01 (1248-1261行目) | ○ |
| C-14 | staleエントリのバックグラウンド再検証 | E-01 (1694-1734行目) | ○ |
| C-15 | ページ/レイアウトのparams/searchParams特別処理 | E-01 (1041-1115行目) | ○ |
| C-16 | cacheSignalのbeginRead/endReadトラッキング | E-01 (1237-1239, 1399-1405行目) | ○ |
| C-17 | pendingRevalidateWritesに保存 | E-01 (1653-1654行目) | ○ |
| C-18 | SWCによるコード変換 | **根拠なし**（SWCプラグイン未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- SWCプラグインによる"use cache"ディレクティブのコード変換処理
  - 候補：`packages/next-swc/` または `crates/` 内のRustコード

## 5) リスクフラグ（レビュー観点）
- 0: use-cache-wrapper.tsの主要ロジックは全て根拠あり
- 1: SWCによるコード変換の詳細が未確認（実行時の入力形式に影響する可能性）

## 6) レビュアーチェックリスト（最小）
- [ ] SWCプラグインによる"use cache"ディレクティブの変換処理を確認
- [ ] プライベートキャッシュのセキュリティ（Cookie漏洩等）を確認
- [ ] 50秒タイムアウトが適切な値か確認
